---
title: Read multiple keys from Workers KV with bulk reads · Changelog
description: You can now retrieve up to 100 keys in a single bulk read request
  to Workers KV.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-04-10-kv-bulk-reads/
  md: https://developers.cloudflare.com/changelog/2025-04-10-kv-bulk-reads/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Read multiple keys from Workers KV with bulk reads

Apr 17, 2025

[KV](https://developers.cloudflare.com/kv/)

You can now retrieve up to 100 keys in a single bulk read request made to Workers KV using the binding.

This makes it easier to request multiple KV pairs within a single Worker invocation. Retrieving many key-value pairs using the bulk read operation is more performant than making individual requests since bulk read operations are not affected by [Workers simultaneous connection limits](https://developers.cloudflare.com/workers/platform/limits/#simultaneous-open-connections).

```js
// Read single key
const key = "key-a";
const value = await env.NAMESPACE.get(key);


// Read multiple keys
const keys = ["key-a", "key-b", "key-c", ...] // up to 100 keys
const values : Map<string, string?> = await env.NAMESPACE.get(keys);


// Print the value of "key-a" to the console.
console.log(`The first key is ${values.get("key-a")}.`)
```

Consult the [Workers KV Read key-value pairs API](https://developers.cloudflare.com/kv/api/read-key-value-pairs/) for full details on Workers KV's new bulk reads support.
