---
title: Multi-Factor Email Authentication · Cloudflare Fundamentals docs
description: Cloudflare's Multi-Factor Email Authentication prevents
  unauthorized access by sending one-time codes to your email.
lastUpdated: 2025-06-30T19:06:55.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/user-profiles/multi-factor-email-authentication/
  md: https://developers.cloudflare.com/fundamentals/user-profiles/multi-factor-email-authentication/index.md
---

## Overview

Cloudflare uses a Multi-Factor Email Authentication (MFA) method for increased account security. MFA prevents customer account takeovers when attackers gain unauthorized access to an account due to an exposed or easily guessed password.

Cloudflare will challenge any login attempt if the user provides the correct credentials from an unrecognized IP address.

![Cloudflare will send an email when your account is logged into from an unknown IP address.](https://developers.cloudflare.com/_astro/hc-import-account_access_email.CGeKtgax_ZswA7E.webp)

Cloudflare challenges the login by sending a one-time code that expires in 30 minutes to the email that we have on file for the account. Once the correct code is provided through the dashboard, your IP will be recorded and further login attempts from that IP address will not be challenged for 90 days.

![When your account is logged into from an unknown IP address, you have to enter an authentication token from an email sent to your email address on file.](https://developers.cloudflare.com/_astro/hc-import-login_authentication.B7wAaxsz_Z240nDV.webp)

Note

Email MFA can only be disabled by enabling [two-factor authentication](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/)

## Troubleshoot MFA

Cloudflare emails are sometimes flagged as spam by the recipient's email service. If you are expecting an authentication token, you should check the spam folder for any Cloudflare emails and configure a filter to allow Cloudflare emails from *<no-reply@notify.cloudflare.com>*\_**.**\_

Other times, emails are rejected by the recipient email service. Cloudflare will try again it will flag your email address after several attempts and no further emails will be sent.

If you still do not receive an email after ensuring your email service is not flagging Cloudflare, contact [Cloudflare Support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

***

## Related resources

* [Secure user access with two-factor authentication](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/)
