---
title: GraphQL Analytics · Cloudflare Magic Network Monitoring docs
description: Use the GraphQL Analytics API to retrieve Magic Network Monitoring flow data.
lastUpdated: 2025-10-16T11:21:23.000Z
chatbotDeprioritize: false
tags: GraphQL
source_url:
  html: https://developers.cloudflare.com/magic-network-monitoring/tutorials/graphql-analytics/
  md: https://developers.cloudflare.com/magic-network-monitoring/tutorials/graphql-analytics/index.md
---

Use the GraphQL Analytics API to retrieve Magic Network Monitoring flow data.

Before you begin, you must have an [API token](https://developers.cloudflare.com/analytics/graphql-api/getting-started/authentication/). For additional help getting started with GraphQL Analytics, refer to [GraphQL Analytics API](https://developers.cloudflare.com/analytics/graphql-api/).

### Obtain your Cloudflare Account ID

To construct a Magic Network Monitoring GraphQL query for an object, you will need a Cloudflare Account ID.

1. Log in to the Cloudflare dashboard, and select your account.

[Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

1. The URL in your browser's address bar should show `https://dash.cloudflare.com/` followed by a hex string. The hex string is your Cloudflare Account ID.

## Explore GraphQL schema with Magic Network Monitoring example

In this section, you will run a test query to retrieve a five minute sum of bits and packets for flows within five minute intervals. You can copy and paste the code below into GraphiQL.

For additional information about the Analytics schema, refer to [Explore the Analytics schema with GraphiQL](https://developers.cloudflare.com/analytics/graphql-api/getting-started/explore-graphql-schema/).

```graphql
query MagicNetworkMonitoring($accountTag: string!, $start: Time, $end: Time) {
  viewer {
    accounts(filter: { accountTag: $accountTag }) {
      mnmFlowDataAdaptiveGroups(
        filter: { datetime_gt: $start, datetime_leq: $end }
        limit: 10
        orderBy: [datetimeFiveMinutes_DESC]
      ) {
        sum {
          bits
          packets
        }
        dimensions {
          datetimeFiveMinutes
        }
      }
    }
  }
}
```

[Run in GraphQL API Explorer](https://graphql.cloudflare.com/explorer?query=I4VwpgTgngBAsgQwOYEsDGA5MAXA7gewgGs58A7FbQlMpACgBIE018QzsAVZALhgGdsEGkgCEAGhgNBCCNj6cUAWzCSGYMgBMFysAEoYAbwBQMGADcUYXJCOmzMZq3bZ+dAGYoANtkh9DjixsHNxIfExBLqEwAL4GJg4OSmRKAGJe+LgAIgjYCACCmggADtgo5mAA4hBsxW72iWaePn5GMEW+ZSoA+kjyUjJykh04ut1eYMDhGpqxDY1eypR8AIwADPOJhJqQAEJQfADaI11gqeVgcDQgvvzdWQCiAMoAwgC6mzDxn2b8IEp2RqNABGlH4PwcxWYRBw4KBZhiEM0ujI-BQ5H4gPhZhOunOFSuZBuYDh8MRQPJDkpiJiQA\&variables=N4IghgxhD2CuB2AXAKmA5iAXCAggYTwHkBVAOWQH0BJAERABoQBnRMAJ0SxACYAGbgKwBaAIwjRI5CO6YRAZkz8AWgxABTeABMufQRIlSAHLIXKQAXyA)
