---
title: Send Bot Management information to origin · Cloudflare Rules docs
description: Send [Bots](/bots/) information to your origin. Refer to [Bot
  Managenent variables](/bots/reference/bot-management-variables/) for a full
  list of available fields.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Headers,Request modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/
  md: https://developers.cloudflare.com/rules/snippets/examples/bot-data-to-origin/index.md
---

```js
export default {
  async fetch(request) {
    // Clone the original request to construct a new request
    const newRequest = new Request(request);
    // Set Bot Management headers on a new request to the origin: https://developers.cloudflare.com/bots/reference/bot-management-variables/#workers-variables
    newRequest.headers.set("bot-score", request.cf.botManagement.score); // bot score (integer)
    newRequest.headers.set(
      "verified-bot",
      request.cf.botManagement.verifiedBot,
    ); // verified bot (boolean)
    newRequest.headers.set("ja4", request.cf.botManagement.ja4); // JA4 fingerprint hash (string)
    // Serve response to the new request from the origin
    return await fetch(newRequest);
  },
};
```
